/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0)

/////////////////////////////////////////////////////////////////////////////////

struct Triangle {
    vec3 v1,v2,v3,normal,color;
};
    
    
    
    
const float viewDist = 999999.0;

vec3 cameraPosition,cameraDirection,cameraRight,cameraRayDir,cameraRayPos;
vec3 cameraUp = vec3(0.0,1.0,0.0);




vec3 rayPos,rayDir;
Triangle rayHit;
float rayHitDist;



vec3 lightDir;
vec4 lightColor = vec4(0.8,0.75,0.75,1.0);



vec3 calcNormal(vec3 p1, vec3 p2, vec3 p3) {
    vec3 u = p2-p1;
    vec3 v = p3-p1;
    
    vec3 normal = vec3(u.y*v.z-u.z*v.y,
                       u.z*v.x-u.x*v.z,
                       u.x*v.y-u.y*v.x);
    
    return normalize(cross(u,v));
    return normalize(normal);
}

#define TEST_CULL

vec3 e1,e2,tv,pv,qv;
float det,inv_det,td,tU,tV;
void rayTriangle(Triangle t) {//http://www.cs.virginia.edu/~gfx/Courses/2003/ImageSynthesis/papers/Acceleration/Fast%20MinimumStorage%20RayTriangle%20Intersection.pdf
    e1 = t.v2-t.v1;
    e2 = t.v3-t.v1;

    pv = cross(rayDir,e2);

	det = dot(e1,pv);
    
    
    #ifdef TEST_CULL
    
    if (det < 0.000001) {
        return;
    }
    tv = rayPos-t.v1;
    
    tU = dot(tv,pv);
    if (tU < 0.0 || tU > det) {
    	return;
    }
    
    qv = cross(tv,e1);
    
    tV = dot(rayDir,qv);
    if (tV < 0.0 || tU+tV > det) {
    	return;
    }
    
    td = dot(e2,qv)*(1.0/det);
    if (td < 0.0) {
        return;
    }
    
    if (td < rayHitDist) {
    	rayHitDist = td;
        rayHit = t;
    }
        
    #else
    
    if (det > -0.00001 && det < 0.00001) {
        return;
    }
    
    inv_det = 1.0/det;

    tv = rayPos-t.v1;
    
    tU = dot(tv,pv)*inv_det;
    if (tU < 0.0 || tU > 1.0) {
        return;
    }
    
    qv = cross(tv,e1);
    
    tV = dot(rayDir,qv)*inv_det;
    if (tV < 0.0 || tV+tU > 1.0) {
        return;
    }
    
    td = dot(e2,qv)*inv_det;
    if (td < rayHitDist) {
    	rayHitDist = td;
        rayHit = t;
    }
    #endif
}

vec3 pN,pP;
void yPlane(Triangle t) {
    
    float rY = t.v1.y-rayPos.y;//get distance from ray to plane on y axis
        
    if (rY < 0.0) {//check if ray going opposite direction from plane, also set the normal based on plane face while were at it
        
        if (rayDir.y >= 0.0) {
            
            return;
            
        } else {
        
			pN = vec3(0.0,1.0,0.0);
            
        }
        
    } else {
        
        if (rayDir.y <= 0.0) {
            
            return;
            
        } else {
            
            pN = vec3(0.0,-1.0,0.0);
        
        }
        
    }
    
    rY = rY/rayDir.y;//calculate number of ray movements until ray
    
    if (rY < rayHitDist) {//check if a closer hit then the current one
        
        pP = rayPos+rY*rayDir;
        
        //check if in width/length of plane
        if (abs(pP.x-t.v1.x) <= t.v2.x && abs(pP.z-t.v1.z) <= t.v2.z) {
            
            //we got a hit
            rayHitDist = rY;
            rayHit = t;
            rayHit.normal = pN;
            
        }
    }
}
    

bool trace(float maxDist) {
    rayHitDist = maxDist;
    
    rayTriangle( Triangle(vec3(-0.202766,-2.41208005,-0.78091699),vec3(-0.202766,-2.20588994,-1.05089605),vec3(-0.202766,-3.09572005,-1.21421599),vec3(-1.0,0.0,-0.0),vec3(0.138684,0.05031,0.007084)));
    rayTriangle( Triangle(vec3(-0.202766,-2.20588994,-1.05089605),vec3(0.202766,-2.20588994,-1.05089605),vec3(-0.202766,-2.8895309,-1.48419499),vec3(0.0,0.53533983,-0.84463674),vec3(0.138684,0.05031,0.007084)));
    rayTriangle( Triangle(vec3(0.202766,-2.20588994,-1.05089605),vec3(0.202766,-2.41208005,-0.78091699),vec3(0.202766,-3.09572005,-1.21421599),vec3(1.0,0.0,0.0),vec3(0.138684,0.05031,0.007084)));
    rayTriangle( Triangle(vec3(0.202766,-2.41208005,-0.78091699),vec3(-0.202766,-2.41208005,-0.78091699),vec3(0.202766,-3.09572005,-1.21421599),vec3(0.0,-0.53534037,0.84463638),vec3(0.138684,0.05031,0.007084)));
    rayTriangle( Triangle(vec3(0.202766,-3.09572005,-1.21421599),vec3(-0.202766,-3.09572005,-1.21421599),vec3(0.245487,-3.36647391,-1.37596595),vec3(0.0,-0.51285738,0.8584739),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.202766,-2.41208005,-0.78091699),vec3(0.202766,-2.20588994,-1.05089605),vec3(-0.202766,-2.41208005,-0.78091699),vec3(0.0,0.79473335,0.60695875),vec3(0.138684,0.05031,0.007084)));
    rayTriangle( Triangle(vec3(-0.245487,-3.36647391,-1.37596595),vec3(-0.245487,-3.11684203,-1.70282698),vec3(0.245487,-3.36647391,-1.37596595),vec3(0.0,-0.79473388,-0.60695803),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.202766,-2.8895309,-1.48419499),vec3(0.202766,-3.09572005,-1.21421599),vec3(0.245487,-3.11684203,-1.70282698),vec3(0.99083394,0.10735731,0.08199124),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(-0.202766,-2.8895309,-1.48419499),vec3(0.202766,-2.8895309,-1.48419499),vec3(-0.245487,-3.11684203,-1.70282698),vec3(0.0,0.69321346,-0.72073233),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(-0.202766,-3.09572005,-1.21421599),vec3(-0.202766,-2.8895309,-1.48419499),vec3(-0.245487,-3.36647391,-1.37596595),vec3(-0.99083394,0.10735714,0.08199111),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(-0.202766,-2.20588994,-1.05089605),vec3(-0.202766,-2.8895309,-1.48419499),vec3(-0.202766,-3.09572005,-1.21421599),vec3(-1.0,0.0,0.0),vec3(0.138684,0.05031,0.007084)));
    rayTriangle( Triangle(vec3(0.202766,-2.20588994,-1.05089605),vec3(0.202766,-2.8895309,-1.48419499),vec3(-0.202766,-2.8895309,-1.48419499),vec3(0.0,0.53533983,-0.84463674),vec3(0.138684,0.05031,0.007084)));
    rayTriangle( Triangle(vec3(0.202766,-2.8895309,-1.48419499),vec3(0.202766,-2.20588994,-1.05089605),vec3(0.202766,-3.09572005,-1.21421599),vec3(1.0,0.0,-0.0),vec3(0.138684,0.05031,0.007084)));
    rayTriangle( Triangle(vec3(-0.202766,-2.41208005,-0.78091699),vec3(-0.202766,-3.09572005,-1.21421599),vec3(0.202766,-3.09572005,-1.21421599),vec3(0.0,-0.53534037,0.84463638),vec3(0.138684,0.05031,0.007084)));
    rayTriangle( Triangle(vec3(-0.202766,-3.09572005,-1.21421599),vec3(-0.245487,-3.36647391,-1.37596595),vec3(0.245487,-3.36647391,-1.37596595),vec3(0.0,-0.51285732,0.85847378),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.202766,-2.20588994,-1.05089605),vec3(-0.202766,-2.20588994,-1.05089605),vec3(-0.202766,-2.41208005,-0.78091699),vec3(0.0,0.79473335,0.60695875),vec3(0.138684,0.05031,0.007084)));
    rayTriangle( Triangle(vec3(-0.245487,-3.11684203,-1.70282698),vec3(0.245487,-3.11684203,-1.70282698),vec3(0.245487,-3.36647391,-1.37596595),vec3(0.0,-0.79473388,-0.60695803),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.202766,-3.09572005,-1.21421599),vec3(0.245487,-3.36647391,-1.37596595),vec3(0.245487,-3.11684203,-1.70282698),vec3(0.990834,0.10735705,0.08199126),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.202766,-2.8895309,-1.48419499),vec3(0.245487,-3.11684203,-1.70282698),vec3(-0.245487,-3.11684203,-1.70282698),vec3(0.0,0.69321346,-0.72073239),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(-0.202766,-2.8895309,-1.48419499),vec3(-0.245487,-3.11684203,-1.70282698),vec3(-0.245487,-3.36647391,-1.37596595),vec3(-0.990834,0.10735721,0.08199137),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(-0.85584497,-2.26676393,-0.62989098),vec3(-0.85584497,-2.01110601,-0.97304797),vec3(-0.59909201,-2.60908198,-0.886675),vec3(-0.8574934,-0.41258058,-0.30737969),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(-0.85584497,-2.01110601,-0.97304797),vec3(0.85584497,-2.01110601,-0.97304797),vec3(-0.59909201,-2.35510206,-1.22757995),vec3(0.0,0.59480518,-0.80386996),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.85584497,-2.01110601,-0.97304797),vec3(0.85584497,-2.26676393,-0.62989098),vec3(0.59909201,-2.35510206,-1.22757995),vec3(0.85749358,-0.41258052,-0.3073796),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.85584497,-2.26676393,-0.62989098),vec3(-0.85584497,-2.26676393,-0.62989098),vec3(0.59909201,-2.60908198,-0.886675),vec3(0.0,-0.60006803,0.79994899),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(-0.59909201,-2.60908198,-0.886675),vec3(-0.59909201,-2.35510206,-1.22757995),vec3(0.59909201,-2.60908198,-0.886675),vec3(0.0,-0.80191404,-0.59743941),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.85584497,-2.26676393,-0.62989098),vec3(0.85584497,-2.01110601,-0.97304797),vec3(-0.85584497,-2.26676393,-0.62989098),vec3(0.0,0.80191386,0.59743971),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(-0.85584497,-2.01110601,-0.97304797),vec3(-0.59909201,-2.35510206,-1.22757995),vec3(-0.59909201,-2.60908198,-0.886675),vec3(-0.85749352,-0.41258064,-0.30737948),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.85584497,-2.01110601,-0.97304797),vec3(0.59909201,-2.35510206,-1.22757995),vec3(-0.59909201,-2.35510206,-1.22757995),vec3(0.0,0.59480512,-0.80386996),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.85584497,-2.26676393,-0.62989098),vec3(0.59909201,-2.60908198,-0.886675),vec3(0.59909201,-2.35510206,-1.22757995),vec3(0.85749352,-0.4125807,-0.30737957),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(-0.85584497,-2.26676393,-0.62989098),vec3(-0.59909201,-2.60908198,-0.886675),vec3(0.59909201,-2.60908198,-0.886675),vec3(0.0,-0.60006797,0.79994893),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(-0.59909201,-2.35510206,-1.22757995),vec3(0.59909201,-2.35510206,-1.22757995),vec3(0.59909201,-2.60908198,-0.886675),vec3(0.0,-0.80191404,-0.59743941),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.85584497,-2.01110601,-0.97304797),vec3(-0.85584497,-2.01110601,-0.97304797),vec3(-0.85584497,-2.26676393,-0.62989098),vec3(0.0,0.80191386,0.59743971),vec3(0.138684,0.138684,0.138684)));
    rayTriangle( Triangle(vec3(0.30000001,-2.4070189,-1.02823806),vec3(0.30000001,-0.80798203,0.89341998),vec3(-0.30000001,-2.4070189,-1.02823806),vec3(0.0,-0.76868236,0.63963068),vec3(0.31999999,0.006154,0.006154)));
    rayTriangle( Triangle(vec3(-0.30000001,-2.4070189,-1.02823806),vec3(-0.30000001,1.03767395,1.01542199),vec3(0.30000001,-2.4070189,-1.02823806),vec3(0.0,0.51023853,-0.86003292),vec3(0.31999999,0.006154,0.006154)));
    rayTriangle( Triangle(vec3(0.30000001,-0.80798203,0.89341998),vec3(0.30000001,1.03767395,1.01542306),vec3(-0.30000001,-0.80798203,0.89341998),vec3(0.0,-0.06595888,0.9978224),vec3(0.31999999,0.006154,0.006154)));
    rayTriangle( Triangle(vec3(-0.30000001,-2.4070189,-1.02823806),vec3(-0.30000001,-0.80798203,0.89341998),vec3(-0.30000001,1.03767395,1.01542199),vec3(-1.0,0.0,0.0),vec3(0.31999999,0.006154,0.006154)));
    rayTriangle( Triangle(vec3(0.30000001,-0.80798203,0.89341998),vec3(0.30000001,-2.4070189,-1.02823806),vec3(0.30000001,1.03767395,1.01542306),vec3(1.0,-0.0,0.0),vec3(0.31999999,0.006154,0.006154)));
    rayTriangle( Triangle(vec3(0.30000001,-0.80798203,0.89341998),vec3(-0.30000001,-0.80798203,0.89341998),vec3(-0.30000001,-2.4070189,-1.02823806),vec3(0.0,-0.76868236,0.63963068),vec3(0.31999999,0.006154,0.006154)));
    rayTriangle( Triangle(vec3(-0.30000001,1.03767395,1.01542199),vec3(0.30000001,1.03767395,1.01542306),vec3(0.30000001,-2.4070189,-1.02823806),vec3(0.00000154,0.51023871,-0.86003286),vec3(0.31999999,0.006154,0.006154)));
    rayTriangle( Triangle(vec3(0.30000001,1.03767395,1.01542306),vec3(-0.30000001,1.03767395,1.01542199),vec3(-0.30000001,-0.80798203,0.89341998),vec3(-0.00000178,-0.06595831,0.9978224),vec3(0.31999999,0.006154,0.006154)));

    yPlane(Triangle(vec3(0.0,-5.0,0.0),vec3(15.0,0.0,15.0),vec3(0.0),vec3(0.0),vec3(0.3)));

    if (rayHitDist >= maxDist) {
    	return false;
    }
    return true;
}



vec4 scene() {
    rayPos = cameraRayPos;
    rayDir = cameraRayDir;

    if (trace(viewDist)) {
        vec3 col = 0.5*rayHit.color+max(0.0,dot(lightDir,rayHit.normal))*rayHit.color;
        
        rayPos += rayDir*rayHitDist+lightDir*0.01;
        rayDir = lightDir;
        if (trace(viewDist)) {
            return col.xyzz*0.5;
        }
        
        return col.xyzz;
    }
    
    return vec4(0.0);
}



const vec2 CENTER_UV = vec2(0.5,0.5);
void main(void) {
	cameraPosition = vec3(sin(iGlobalTime*0.1)*10.0,2.0,cos(iGlobalTime*0.1)*5.0);
    cameraDirection = normalize(-cameraPosition);

    lightDir = normalize(vec3(sin(iGlobalTime)*10.0,8.0,cos(iGlobalTime)*10.0));
    
    
	vec2 cUv = (gl_FragCoord.xy / iResolution.xy)-CENTER_UV;
    cUv.x *= iResolution.x/iResolution.y;
	
    //camera vectors
    cameraRight = cross(cameraDirection,cameraUp);
    cameraUp = cross(cameraRight,cameraDirection);
    
    //calculate ray from uv and camera vectors
    vec3 rPoint = cUv.x*cameraRight +
                  cUv.y*cameraUp +
        		  cameraPosition + cameraDirection;
    
  	cameraRayDir = normalize(rPoint-cameraPosition);
    cameraRayPos = cameraPosition;
    
    
    gl_FragColor = scene();
}